package main

import (
	"flag"
	"fmt"
	"log"
	"net/http"
	"strings"
	"time"

	"github.com/prometheus/client_golang/prometheus/promhttp"
	"github.com/zhentianxiang/systemd-exporter/monitor" // 监控模块
)

func main() {
	// 解析命令行参数
	serverArg := flag.String("server", "", "以逗号分隔的服务名，例如：--server=redis,mysqld")
	port := flag.Int("port", 9105, "Prometheus 监听端口，例如：--port=9105")
	flag.Parse()

	// 没有指定服务时退出
	if *serverArg == "" {
		log.Fatal("请通过 --server 参数指定需要监控的 systemd 服务")
	}

	// 拆分服务名为数组
	services := strings.Split(*serverArg, ",")
	log.Printf("监控以下服务: %v\n", services)

	// 初始化 Prometheus 指标
	monitor.InitMetrics()

	// 启动 HTTP 服务，暴露 Prometheus 指标
	go func() {
		http.Handle("/metrics", promhttp.Handler())
		log.Printf("Exporter 已启动，监听端口 %d\n", *port)
		log.Fatal(http.ListenAndServe(fmt.Sprintf(":%d", *port), nil))
	}()

	// 每 10 秒更新一次服务状态
	ticker := time.NewTicker(10 * time.Second)
	go func() {
		for range ticker.C {
			monitor.UpdateServiceStatus(services)
		}
	}()

	// 阻塞主线程
	select {}
}
