package monitor

import "github.com/prometheus/client_golang/prometheus"

var serviceStatus = prometheus.NewGaugeVec(
	prometheus.GaugeOpts{
		Name: "systemd_service_status",
		Help: "systemd 服务状态 (1=运行, 0=停止)",
	},
	[]string{"service"},
)

var serviceLastChange = prometheus.NewGaugeVec(
	prometheus.GaugeOpts{
		Name: "systemd_service_last_change",
		Help: "systemd 服务上次状态变更为 active 的 Unix 时间戳",
	},
	[]string{"service"},
)

var serviceRestarted = prometheus.NewGaugeVec(
	prometheus.GaugeOpts{
		Name: "systemd_service_restarted",
		Help: "systemd 服务是否刚刚重启 (1=是, 0=否)",
	},
	[]string{"service"},
)

func InitMetrics() {
	prometheus.MustRegister(serviceStatus)
	prometheus.MustRegister(serviceLastChange)
	prometheus.MustRegister(serviceRestarted)
}
